{*************************************************************
**************************************************************
*   Ejemplo sobre el uso del componente TBuscador, que       *
*   acompaa la serie sobre Hilos de Ejecucin,              *
*   y que corresponde al captulo V de la misma: Thread V.   *
*                                                            *
*   Autores: Salvador Jover      mailto: s.jover@wanadoo.es  *
*            Jose Manuel Navarro mailto:jmnavarro@lexnova.es *
*                                                            *
*   Revista Sintesis N 15  http://www.GrupoAlbor.com/       *
**************************************************************
**************************************************************}

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, ImgList, Buscador, ShlObj;

type

  TMainForm = class(TForm)
    Label1z: TLabel;
    edi_Ruta: TEdit;
    cbx_Subcarpetas: TCheckBox;
    Bevel1: TBevel;
    btn_Buscar: TButton;
    Label1: TLabel;
    ImageList1: TImageList;
    cbx_Pausa: TCheckBox;
    edi_Token: TEdit;
    Label2: TLabel;
    btn_AnadirRuta: TButton;
    Buscador1: TBuscador;
    btn_Cancelar: TButton;
    stb_estado: TStatusBar;
    Label3: TLabel;
    Bevel2: TBevel;
    procedure btn_BuscarClick(Sender: TObject);
    procedure cbx_PausaClick(Sender: TObject);
    procedure btn_AnadirRutaClick(Sender: TObject);
    procedure Buscador1Abort(Sender: TObject; AIncidencia: TIncidencia);
    procedure Buscador1End(Sender: TObject);
    procedure btn_CancelarClick(Sender: TObject);
  private
    procedure Estado_Ejecucion;
    procedure Estado_Inactivo;
  public
  end;

 function MiFunRetorno(hWnd: HWND; uMsg: UINT; lParam: LPARAM; lpData: LPARAM): Integer; stdcall;

var
  MainForm: TMainForm;


implementation


{$R *.DFM}


//--------------------------------------------------------
// Objetivo: Controlar el estado de los objetos de la
//           ventana segn el estado Ejecucin/No Ejecucin
//
procedure TMainForm.Estado_Ejecucion;
begin
   edi_Ruta.Enabled:= False;
   edi_Token.Enabled:= False;
   cbx_Pausa.Enabled:= True;
   cbx_Subcarpetas.Enabled:= False;
   btn_Buscar.Enabled:= False;
   btn_Cancelar.Enabled:= True;
   btn_AnadirRuta.Enabled:= False;
end;


//--------------------------------------------------------
// Objetivo: Controlar el estado de los objetos de la
//           ventana segn el estado Ejecucin/No Ejecucin
//
procedure TMainForm.Estado_Inactivo;
begin
   edi_Ruta.Enabled:= True;
   edi_Token.Enabled:= True;
   cbx_Pausa.Enabled:= False;
   cbx_Subcarpetas.Enabled:= True;
   btn_Buscar.Enabled:= True;
   btn_Cancelar.Enabled:= False;
   btn_AnadirRuta.Enabled:= True;
end;


//--------------------------------------------------------
// Objetivo: Iniciar la busqueda.
// Comentario: Como hemos dado la posibilidad de que el
//             usuario proporcione varias rutas, encerrndolas
//             mediante dobles comillas, debemos separar una
//             a una, quitando las dobles comillas, para hacer
//             la entrega del parmetro en Add( ).
//             Hemos elegido dobles comillas, pero podamos haber
//             hecho uso simplemente de un punto y coma como
//             separacin
//
procedure TMainForm.btn_BuscarClick(Sender: TObject);
var
  i, k: integer;
  s, salida: String;
  Count: Integer;
begin
  Estado_Ejecucion;

  // El fichero a buscar
  buscador1.Token:= edi_Token.Text;
  // hay subcarpetas? <--------- Depende del CheckBox
  buscador1.HaySubcarpetas := cbx_Subcarpetas.Checked;

  salida:= edi_Ruta.text;
  Count:= Length(salida)-1;
  k:= Count;
  i:= Count;
  while i >= 1 do   // recorremos la cadena
     begin
     if salida[i] = '"' then
       begin
       s:= Copy(salida, i+1, k - i);
       k:= i-2;
//       if s[length(s)] <> '\' then s:= s + '\';
       buscador1.Add(s); //  <-------------- Mtodo Add( ) del Buscador.
       i:= i - 1;
       end;
     i:= i - 1;
     end;
   buscador1.Execute;  // <------------------ Inicio de la Ejecucin
end;


//--------------------------------------------------------
// Objetivo: Pausar la busqueda.
//
procedure TMainForm.cbx_PausaClick(Sender: TObject);
begin
  buscador1.Pause(cbx_pausa.checked);
end;


//--------------------------------------------------------
// Objetivo: Restablecer el estado inactivo para permitir una
//           nueva bsqueda. Si la bsqueda ha sido cancelada
//           por el usuario, debemos volver a activar algunos
//           controles y desactivar otros.
//           Por ejemplo, debemos habilitar a enabled el botn
//           de Buscar y el de [Aadir Ruta], y desactivar el
//           de Cancelar.
//
procedure TMainForm.Buscador1Abort(Sender: TObject;
  AIncidencia: TIncidencia);
begin
   Estado_Inactivo;
end;


//--------------------------------------------------------
// Objetivo: Restablecer el estado inactivo para permitir una
//           nueva bsqueda. En este caso, la busqueda ha
//           finalizado de forma natural y muestra los resultados
//           obtenidos. Nos preparamos para que se pueda iniciar
//           una nueva bsqueda.
//
procedure TMainForm.Buscador1End(Sender: TObject);
begin
   Estado_Inactivo;
end;

//--------------------------------------------------------
// Objetivo: El usuario desea cancelar la busqueda
//
procedure TMainForm.btn_CancelarClick(Sender: TObject);
begin
   Buscador1.Cancel;
end;


//--------------------------------------------------------
// Objetivo: Aadir una ruta haciendo uso de un cuadro de dilogo
// Comentario: Hacemos uso de la funcin SHBrowseForFolder() del
//             Api de Windows, que nos muestra las carpetas para
//             la eleccin de una.
//             De haber hecho uso de Delphi 6 existe un componente
//             que nos puede servir adecuadamente y que nos permitir
//             hacer multiseleccin de archivos: el truco es usar un
//             descendiente y acceder a la propiedad multiselect que
//             es declarada como Protegida y Activarla.
//             Este componente es TShellTreeView y se encuentra en la
//             pestaa [Samples].
//             En este caso no hemos hecho uso de el para no hacer
//             incompatible el ejemplo con Delphi 5.
//
procedure TMainForm.btn_AnadirRutaClick(Sender: TObject);
var
  ItemIDList       : PItemIDList;
  Registro_Info: TBrowseInfo;
  Ruta         : array[0..MAX_PATH] of char;
begin
  // Preparamos el registro TBrowseInfo que almacena informacin
  // sobre el cuadro de dilogo y la raiz del arbol, as como el
  // titulo de la ventana y los flags sobre que tipo de carpetas
  // debe mostrar.

  FillChar(Registro_Info, SizeOf(Registro_Info), 0);
  with Registro_Info do begin
     hwndOwner      := MainForm.Handle; // Ventana propietaria del cuadro de dilogo
     pidlRoot       := nil;             // raiz del arbol
     pszDisplayName := Ruta;            // seleccion del usuario
     lpszTitle      := 'Elige un directorio para la busqueda';    // Titulo
                       // ORDENADORES (Pc)   y  DIRECTORIOS DEL SISTEMA
     ulFlags        := BIF_BROWSEFORCOMPUTER or BIF_RETURNONLYFSDIRS;
     lpfn           := @MiFunRetorno;   // podra hacer sido NIL
     lParam         := 0;
  end;
  ItemIDList := SHBrowseForFolder(Registro_Info); // Ejecucin del cuadro de dilogo
  SHGetPathFromIDList(ItemIDList, @Ruta); // Tras ser cerrado, extraemos la ruta
  // y la mostramos en el cuadro de edicin encerrada entre comillas
  if ItemIDList <> nil then edi_Ruta.Text := edi_Ruta.Text + '"' + Ruta + '"';
end;


//------------------------------------------------------------------
// Objetivo: Nuestra respuesta a la accin de usuario.
// Comentario: Funcin de respuesta que puede ser usada para controlar la
//             accin del usuario y la generacin de eventos que provoca.
//             En este caso no hacemos nada. Debe devolver siempre 0.
//
function MiFunRetorno(hWnd: HWND; uMsg: UINT; lParam: LPARAM; lpData: LPARAM): Integer;
begin
 Result:= 0;
end;


end.
